using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SMAT_CE
{
    public partial class uc_SpeciesFractionsCalculationOptionsA : ucBase
    {
        public uc_SpeciesFractionsCalculationOptionsA()
        {
            InitializeComponent();

            #region Language added by Yangwenwei
            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
            #endregion
        }

        private void uc_SpeciesFractionsCalculationOptionsA_Load(object sender, EventArgs e)
        {
            cboItpCrustalA.Items.Add("Equal Weighting of Monitors");
            cboItpCrustalA.Items.Add("Inverse Distance Weights");
            cboItpCrustalA.Items.Add("Inverse Distance Squared Weights");

            cboItpDONA.Items.Add("Equal Weighting of Monitors");
            cboItpDONA.Items.Add("Inverse Distance Weights");
            cboItpDONA.Items.Add("Inverse Distance Squared Weights");

            cboItpECA.Items.Add("Equal Weighting of Monitors");
            cboItpECA.Items.Add("Inverse Distance Weights");
            cboItpECA.Items.Add("Inverse Distance Squared Weights");

            cboItpNH4A.Items.Add("Equal Weighting of Monitors");
            cboItpNH4A.Items.Add("Inverse Distance Weights");
            cboItpNH4A.Items.Add("Inverse Distance Squared Weights");

            cboItpNO3A.Items.Add("Equal Weighting of Monitors");
            cboItpNO3A.Items.Add("Inverse Distance Weights");
            cboItpNO3A.Items.Add("Inverse Distance Squared Weights");

            cboItpOCA.Items.Add("Equal Weighting of Monitors");
            cboItpOCA.Items.Add("Inverse Distance Weights");
            cboItpOCA.Items.Add("Inverse Distance Squared Weights");

            cboItpPM25A.Items.Add("Equal Weighting of Monitors");
            cboItpPM25A.Items.Add("Inverse Distance Weights");
            cboItpPM25A.Items.Add("Inverse Distance Squared Weights");

            cboItpSaltA.Items.Add("Equal Weighting of Monitors");
            cboItpSaltA.Items.Add("Inverse Distance Weights");
            cboItpSaltA.Items.Add("Inverse Distance Squared Weights");

            cboItpSO4A.Items.Add("Equal Weighting of Monitors");
            cboItpSO4A.Items.Add("Inverse Distance Weights");
            cboItpSO4A.Items.Add("Inverse Distance Squared Weights");

            choAdvancedOptions_CheckStateChanged(sender, e);
        }

        private void lblImproveMonitorData_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_1_4_species_fraction_options.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblPMMonitorData_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_1_4_species_fraction_options.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void choAdvancedOptions_CheckStateChanged(object sender, EventArgs e)
        {
            try
            {
                if (choAdvancedOptions.Checked)
                    this.Height = 1445;
                else this.Height = 780;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void rbtnDONA_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                cboItpNH4A.Enabled = false;
                nudownNH4DistanceA.Enabled = false;
                nudownNH4PercentageA.Enabled = false;
                cboItpDONA.Enabled = true;
                nudownDONDistanceA.Enabled = true;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void rbtnMeasuredA_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                cboItpDONA.Enabled = false;
                nudownDONDistanceA.Enabled = false;
                nudownNH4PercentageA.Enabled = true;
                cboItpNH4A.Enabled = true;
                nudownNH4DistanceA.Enabled = true;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboIMPROVEEndYaerA_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboIMPROVEEndYaerA.Text) < Convert.ToInt32(cboIMPROVEStartYaerA.Text))
                    cboIMPROVEStartYaerA.Text = cboIMPROVEEndYaerA.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboIMPROVEStartYaerA_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboIMPROVEEndYaerA.Text) < Convert.ToInt32(cboIMPROVEStartYaerA.Text))
                    cboIMPROVEEndYaerA.Text = cboIMPROVEStartYaerA.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboPMStartYaerA_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboPMEndYaerA.Text) < Convert.ToInt32(cboPMStartYaerA.Text))
                    cboPMEndYaerA.Text = cboPMStartYaerA.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void cboPMEndYaerA_SelectionChangeCommitted(object sender, EventArgs e)
        {
            try
            {
                if (Convert.ToInt32(cboPMEndYaerA.Text) < Convert.ToInt32(cboPMStartYaerA.Text))
                    cboPMStartYaerA.Text = cboPMEndYaerA.Text;
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
